package com.bycom.versapro.MenuTypes.WordPress.Adapters;

import static com.bycom.versapro.Utils.AppUtil.getImageTransition;

import android.content.Intent;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.bycom.versapro.R;
import com.bycom.versapro.Utils.PrefUtil;
import com.bycom.versapro.MenuTypes.WordPress.UserInterface.WPPostFragment;

import com.bycom.versapro.MenuTypes.WordPress.UserInterface.WPPostDetailsFragment;
import com.squareup.picasso.Picasso;
import com.wordpress.restapi.Serializables.WPCategory;
import com.wordpress.restapi.Serializables.WPPost;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class WPPostAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {


    public static final int ITEM_POST = 1;
    public static final int ITEM_LOADER = 2;

    public static final int ITEM_STICKY_POST = 3;

    public static final int ITEM_BANNER_AD= 4;

    public static final int LAYOUT_STICKY_LIST = 5;

    public static final int LAYOUT_CATEGORY_LIST = 6;

    public static final int LAYOUT_CATEGORY_DETAILS = 7;
    AppCompatActivity activity;
    public ArrayList<WPPost> posts;

    ArrayList<WPPost> stickyPosts;


    WPCategory category;

    Fragment fragment;

    String BASE_URL;

    private final Set<Integer> adLoadedPositions = new HashSet<>();



    public WPPostAdapter(AppCompatActivity activity, Fragment fragment, ArrayList<WPPost> stickyPosts, ArrayList<WPPost> posts, String BASE_URL, WPCategory category) {
        this.fragment = fragment;
        this.activity = activity;
        this.posts = posts;
        this.stickyPosts = stickyPosts;
        this.BASE_URL = BASE_URL;
        this.category = category;

    }



    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {


        LayoutInflater inflater = LayoutInflater.from(activity);
        if (viewType == ITEM_POST) {
            View view = inflater.inflate(R.layout.item_wp_post, parent, false);
            return new PostViewHolder(view);
        } else if (viewType == ITEM_LOADER) {
            View view = inflater.inflate(R.layout.item_load_more_progress, parent, false);
            return new LoaderViewHolder(view);
        }else if (viewType == ITEM_BANNER_AD) {
            View view = inflater.inflate(R.layout.item_banner_ad, parent, false);
            return new BannerAdViewHolder(view);
        }else if(viewType == LAYOUT_CATEGORY_LIST){
            View view = inflater.inflate(R.layout.layout_wp_home, parent, false);
            return new HomeViewHolder(view);
        }else if(viewType == LAYOUT_STICKY_LIST){
            View view = inflater.inflate(R.layout.layout_wp_home, parent, false);
            return new HomeViewHolder(view);
        }else if(viewType == ITEM_STICKY_POST) {
            View view = inflater.inflate(R.layout.item_wp_sticky_post, parent, false);
            return new PostViewHolder(view);
        }else if(viewType == LAYOUT_CATEGORY_DETAILS){
            View view = inflater.inflate(R.layout.layout_wp_category, parent, false);
            return new CategoryViewHolder(view);
        }



        throw new IllegalArgumentException("Invalid view type");




    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {

        WPPost post = posts.get(position);

        if(viewHolder instanceof PostViewHolder holder){


            DisplayMetrics displayMetrics = holder.itemView.getContext().getResources().getDisplayMetrics();


            if(!post.getImageUrl().isEmpty()){
                holder.iv_post.setVisibility(View.VISIBLE);
                Picasso.get()
                        .load(post.getImageUrl())
                        .resize(displayMetrics.widthPixels,displayMetrics.heightPixels)
                        .centerInside()
                        .into(holder.iv_post);
            }else holder.iv_post.setVisibility(View.GONE);




            holder.tv_title.setText(post.getTitle());

            holder.tv_date.setText(post.getPublished_date());

            holder.tv_category_name.setSelected(true);


            try {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < post.getCategoryIds().size(); i++) {
                    if (!stringBuilder.toString().isEmpty()) stringBuilder.append(" • ");
                    WPCategory wpCategory = PrefUtil.getCategory(post.getBASE_URL(),post.getCategoryIds().get(i));
                    if(wpCategory!=null) stringBuilder.append(wpCategory.getName());
                }
                if(stringBuilder.toString().isEmpty()) throw new Exception();
                holder.tv_category_name.setVisibility(View.VISIBLE);
                holder.tv_category_name.setText(stringBuilder.toString());
            } catch (Exception e) {
                if(post.getType() == ITEM_STICKY_POST) {
                    holder.tv_category_name.setVisibility(View.VISIBLE);
                    holder.tv_category_name.setText(R.string.featured_label);
                }
                else holder.tv_category_name.setVisibility(View.GONE);
            }



            holder.iv_post.setTransitionName(UUID.randomUUID().toString());


            holder.itemView.setOnClickListener(v ->{


                WPPostDetailsFragment.BookmarkRemovedCallback callback = () -> {
                    if (fragment instanceof WPPostFragment wp_post_fragment) {
                        if (wp_post_fragment.TYPE == WPPostFragment.TYPE_POSTS_BY_BOOKMARK) {
                            new Handler().postDelayed(() -> {
                                posts.remove(holder.getAdapterPosition());
                                notifyItemRemoved(holder.getAdapterPosition());
                                if (posts.isEmpty()) wp_post_fragment.showErrorScreen();
                            }, 400);

                        }
                    }
                };


                WPPostDetailsFragment postDetailsFragment = new WPPostDetailsFragment();
                postDetailsFragment.drawable_post = holder.iv_post.getDrawable();
                postDetailsFragment.post = post;
                postDetailsFragment.bookmarkRemovedCallback = callback;
                postDetailsFragment.transitionName = holder.iv_post.getTransitionName();


                FragmentTransaction transaction = activity.getSupportFragmentManager().beginTransaction();

                transaction.hide(fragment);
                transaction.add(R.id.container, postDetailsFragment);
                transaction.addToBackStack(null);


                fragment.setSharedElementReturnTransition(getImageTransition());
                postDetailsFragment.setSharedElementEnterTransition(getImageTransition());
                transaction.addSharedElement(holder.iv_post, holder.iv_post.getTransitionName());


                transaction.commit();


            });





        }

        if(viewHolder instanceof BannerAdViewHolder holder){


            holder.banner_ad_container.removeAllViews();


            if (post.getAdView().getParent() != null) {
                ((ViewGroup) post.getAdView().getParent()).removeView(post.getAdView());
            }

            holder.banner_ad_container.addView(post.getAdView());





        }


        if(viewHolder instanceof CategoryViewHolder holder){


            holder.tv_category_name.setText(category.getName());
            String post_count = activity.getString(R.string.post_count_label) + ": " + category.getPost_count();
            holder.tv_post_count.setText(post_count);
            if(category.getDescription().isEmpty()) holder.tv_category_desc.setVisibility(View.GONE);
            else {
                holder.tv_category_desc.setText(category.getDescription());
                holder.tv_category_desc.setVisibility(View.VISIBLE);
            }

            holder.iv_share.setOnClickListener(v -> {
                Intent shareIntent = new Intent(Intent.ACTION_SEND);
                shareIntent.setType("text/plain");
                shareIntent.putExtra(Intent.EXTRA_TEXT, category.getLink());
                Intent chooserIntent = Intent.createChooser(shareIntent, "Share URL");
                activity.startActivity(chooserIntent);
            });


        }

        if(viewHolder instanceof HomeViewHolder holder) {


            if(posts.get(position).getType() == LAYOUT_CATEGORY_LIST){

                HashMap<Integer, WPCategory> categories = PrefUtil.getAllCategories(BASE_URL);

                LinearLayoutManager layoutManager = new LinearLayoutManager(activity, LinearLayoutManager.HORIZONTAL, false);

                holder.recyclerView.setLayoutManager(layoutManager);

                WPCategoryAdapter adapter = new WPCategoryAdapter(activity,fragment,categories,BASE_URL);

                holder.recyclerView.setAdapter(adapter);

            }


            if(posts.get(position).getType() == LAYOUT_STICKY_LIST) {


                LinearLayoutManager layoutManager = new LinearLayoutManager(activity, LinearLayoutManager.HORIZONTAL, false);
                holder.recyclerView.setLayoutManager(layoutManager);


                WPPostAdapter adapter = new WPPostAdapter(activity,fragment,null,stickyPosts,BASE_URL,null);
                holder.recyclerView.setAdapter(adapter);

            }


        }


    }




    public void addMorePosts(ArrayList<WPPost> posts){
        this.posts.addAll(posts);
        this.notifyItemRangeInserted(this.getItemCount(),posts.size());
    }


    @Override
    public int getItemViewType(int position) {
        return posts.get(position).getType();
    }



    @Override
    public int getItemCount() {
        return posts.size();
    }

    public static class PostViewHolder extends RecyclerView.ViewHolder {

        ImageView iv_post;

        TextView tv_title;

        TextView tv_date,tv_category_name;



        public PostViewHolder(@NonNull View itemView) {
            super(itemView);


            iv_post = itemView.findViewById(R.id.iv_post);
            tv_title = itemView.findViewById(R.id.tv_title);
            tv_date = itemView.findViewById(R.id.tv_date);
            tv_category_name = itemView.findViewById(R.id.tv_category_name);



        }
    }


    public static class LoaderViewHolder extends RecyclerView.ViewHolder{


        public LoaderViewHolder(@NonNull View itemView) {
            super(itemView);



        }
    }

    public static class HomeViewHolder extends RecyclerView.ViewHolder{


        RecyclerView recyclerView;


        public HomeViewHolder(@NonNull View itemView) {
            super(itemView);


            recyclerView = itemView.findViewById(R.id.recyclerView);


        }
    }

    public static class BannerAdViewHolder extends RecyclerView.ViewHolder{

        public RelativeLayout banner_ad_container;



        public BannerAdViewHolder(@NonNull View itemView) {
            super(itemView);

            banner_ad_container = itemView.findViewById(R.id.banner_ad_container);


        }
    }
    public static class CategoryViewHolder extends RecyclerView.ViewHolder{


        TextView tv_category_name,tv_category_desc,tv_post_count;
        ImageView iv_share,iv_mcv;

        public CategoryViewHolder(@NonNull View itemView) {
            super(itemView);

            tv_category_name = itemView.findViewById(R.id.tv_category_name);
            tv_category_desc = itemView.findViewById(R.id.tv_category_desc);
            tv_post_count = itemView.findViewById(R.id.tv_post_count);
            iv_share = itemView.findViewById(R.id.iv_share);
            iv_mcv = itemView.findViewById(R.id.iv_mcv);

        }
    }


}
